<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slick-theme.css')); ?>">
    <link rel="stylesheet"
          href="https://maxst.icons8.com/vue-static/landings/line-awesome/font-awesome-line-awesome/css/all.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title'); ?>
    Dashboard
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <!-- Content area -->
    <div class="content">
        <div class="row">
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="mr-3 align-self-center">
                            <i class="fas fa-newspaper fa-3x text-primary"></i>
                        </div>
                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_adds']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">total adds</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="mr-3 align-self-center">
                            <i class="fas fa-users fa-3x text-indigo"></i>
                        </div>
                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_users']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">total users</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="mr-3 align-self-center">
                            <i class="fas fa-list-ol fa-3x text-primary"></i>
                        </div>
                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_category']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">Total Category</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="ml-3 align-self-center">
                            <i class="fas fa-ribbon fa-3x text-danger"></i>
                        </div>
                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_banner']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">TOTAL BANNER</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="ml-3 align-self-center">
                            <i class="fas fa-calendar fa-3x text-danger"></i>
                        </div>

                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_attribute']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">total attributes</span>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="ml-3 align-self-center">
                            <i class="fas fa-user-shield fa-3x text-purple"></i>
                        </div>
                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_contact']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">total contact us</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card card-body">
                    <div class="media">
                        <div class="ml-3 align-self-center">
                            <i class="fas fa-user-tie fa-3x text-pink"></i>
                        </div>
                        <div class="media-body text-right">
                            <h3 class="font-weight-semibold mb-0"><?php echo e($data['total_admins']); ?></h3>
                            <span class="text-uppercase font-size-sm text-muted">total admins</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <!-- Clients -->
                <div class="card">
                    <div class="card-header header-elements-sm-inline">
                        <h6 class="card-title">Adds</h6>
                        <div class="header-elements">
                            <span class="badge badge-success badge-pill"></span>

                        </div>
                    </div>
                    <div class="card-body d-sm-flex align-items-sm-center justify-content-sm-between flex-sm-wrap">
                        <div class="d-flex align-items-center mb-3 mb-sm-0">
                            <div id="campaigns-donut"></div>
                            <div class="ml-3">
                                <h5 class="font-weight-semibold mb-0"><span
                                        class="text-success font-size-sm font-weight-normal"><i
                                            class="icon-arrow-up12"></i>Total Adds</span></h5>
                                <span class="badge badge-mark border-success mr-1"></span> <span
                                    class="text-muted"><?php echo e(\Carbon\Carbon::now()); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table text-nowrap">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('translate.id'); ?></th>
                                <th>Information</th>
                                <th><?php echo app('translator')->get('translate.title'); ?></th>
                                <th><?php echo app('translator')->get('translate.category'); ?></th>
                                <th><?php echo app('translator')->get('translate.child'); ?></th>
                                <th><?php echo app('translator')->get('translate.price'); ?></th>
                                <th>View</th>
                            </tr>
                            </thead>
                            <tbody>


                            <?php $__currentLoopData = $adds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $add): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($add->id); ?></td>
                                    <td>
                                       <p> <b>Fullname: </b> <?php echo e($add?->User?->fullname); ?></p>
                                       <p> <b>Email : </b> <?php echo e($add?->User?->email); ?></p>
                                       <p> <b>Phone : </b> <?php echo e($add?->User?->phone); ?></p>
                                       <p> <b>Gender : </b> <?php echo e($add?->User?->gender); ?></p>
                                    </td>
                                    <td><?php echo e($add->title); ?></td>
                                    <td><?php echo e($add?->categories?->title); ?></td>
                                    <td><?php echo e($add?->child?->title); ?></td>
                                    <td><?php echo e($add?->price); ?> - (<?php echo e($add->currency_type); ?>)</td>
                                    <td><a href="<?php echo e(route('adds.show',[$add->id])); ?>" target="_blank"
                                           class="dropdown-item"> <i class="fa fa-eye me-2"></i>View</a></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr class="table-active table-border-double">
                                <td colspan="6"><?php echo e(\Carbon\Carbon::now()->format('l')); ?></td>
                                <td class="text-right">
                                    <span class="progress-meter" id="today-progress" data-progress="30"></span>
                                </td>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- End Clients -->

                <!-- Project -->
                <div class="card">
                    <div class="card-header header-elements-sm-inline">
                        <h6 class="card-title">PACKAGES </h6>
                        <div class="header-elements">
                            <span class="badge badge-success badge-pill"></span>
                        </div>
                    </div>
                    <div class="card-body d-sm-flex align-items-sm-center justify-content-sm-between flex-sm-wrap">
                        <div class="d-flex align-items-center mb-3 mb-sm-0">
                            <div id="campaigns-donut"></div>
                            <div class="ml-3">
                                <h5 class="font-weight-semibold mb-0"><span
                                        class="text-success font-size-sm font-weight-normal"><i
                                            class="icon-arrow-up12"></i> Total Packages </span></h5>
                                <span class="badge badge-mark border-success mr-1"></span> <span
                                    class="text-muted"><?php echo e(\Carbon\Carbon::now()); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table text-nowrap">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('translate.title'); ?></th>
                                <th><?php echo app('translator')->get('translate.price'); ?></th>
                                <th>Package Days</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($package->title); ?></td>
                                    <td><?php echo e($package->price); ?> - (IQD)</td>
                                    <td><?php echo e($package->package_days); ?> </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr class="table-active table-border-double">
                                <td colspan="4"><?php echo e(\Carbon\Carbon::now()->format('l')); ?></td>
                                <td class="text-right">
                                    <span class="progress-meter" id="today-progress" data-progress="30"></span>
                                </td>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- End Projects -->

            </div>
        </div>
    </div>
    <!-- /content area -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    
<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/miladmajeed/Desktop/Gigant/Sale-Point/resources/views/home.blade.php ENDPATH**/ ?>