<!-- Vertical Edit form modal -->
<script src="<?php echo e(asset('global_assets/js/plugins/forms/selects/select2.min.js')); ?>"></script>
<div id="modal_form_vertical_edit" class="modal fade" tabindex="-1">
    <div class="modal-dialog modal-full">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h5 class="modal-title text-white"><?php echo app('translator')->get('translate.edit_package'); ?></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="" class="form-validate-jquery main_form_edit" id="main_form_edit">
                    <?php echo e(method_field('PUT')); ?>

                    <?php echo e(csrf_field()); ?>

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en_edit" class="nav-link active"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.en'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku_edit" class="nav-link"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.ku'); ?></a></li>
                        <li class="nav-item"><a href="#lang_ar_edit" class="nav-link"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.ar'); ?></a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title" id="title" required
                                       placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description'); ?></label>
                                    <textarea rows="7" cols="3" class="form-control" id="description" name="description"
                                              placeholder="<?php echo app('translator')->get('translate.description'); ?>"></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="mb-2"><?php echo app('translator')->get('translate.Image'); ?></label>
                                <div class="input-group" data-toggle="aizuploader" data-type="image"
                                     data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            <?php echo app('translator')->get('translate.browse'); ?></div>
                                    </div>
                                    <div class="form-control file-amount"><?php echo app('translator')->get('translate.choose_file'); ?></div>
                                    <input type="hidden" name="image" id="image" required class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                            </div>

                            <div class="row">


                                <div class="col-lg-4">
                                    <div class="form-group mb-3">
                                        <label class="mb-2"><?php echo app('translator')->get('translate.price'); ?> (IQD)</label>
                                        <input type="text" class="form-control" name="price" id="price" required
                                               placeholder="<?php echo app('translator')->get('translate.price'); ?>">
                                    </div>
                                </div>

                                <div class="col-lg-4">
                                    <div class="form-group mb-3">
                                        <label class="mb-2">Package Days</label>
                                        <input type="text" class="form-control" name="package_days" id="package_days"
                                               required
                                               placeholder="Package Days">
                                    </div>
                                </div>

                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label class="mb-2" for="favcolor">Color Code</label><br>
                                        <input type="color" id="code" name="code" value="">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title_ku" id="title_ku" required
                                       placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description'); ?></label>
                                    <textarea rows="7" cols="3" class="form-control" id="description_ku_edit"
                                              name="description_ku"
                                              placeholder="<?php echo app('translator')->get('translate.description'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title_ar" id="title_ar" required
                                       placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description'); ?></label>
                                    <textarea rows="7" cols="3" class="form-control" id="description_ar_edit"
                                              name="description_ar"
                                              placeholder="<?php echo app('translator')->get('translate.description'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical Edit form modal -->
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/packages/update.blade.php ENDPATH**/ ?>