<!-- Vertical form modal -->
<div id="modal_form_vertical" class="modal fade" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-full">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h6 class="modal-title"><?php echo app('translator')->get('translate.add_banner'); ?></h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="<?php echo e(route('banners.store')); ?>" class="form-validate-jquery main_form"
                      id="main_form">
                    <?php echo e(csrf_field()); ?>

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en" class="nav-link active"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.en'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku" class="nav-link"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.ku'); ?></a></li>
                        <li class="nav-item"><a href="#lang_ar" class="nav-link"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.ar'); ?></a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title_english'); ?></label>
                                <input type="text" class="form-control" name="title" required
                                       placeholder="<?php echo app('translator')->get('translate.title_english'); ?>">
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label"><?php echo app('translator')->get('translate.banner_type'); ?></label>
                                <select name="banner_type" id="banner_type" class="form-control">
                                    <option value="normal" selected><?php echo app('translator')->get('translate.normal'); ?></option>
                                    <option value="link"><?php echo app('translator')->get('translate.link'); ?></option>
                                    <option value="product">Adds</option>
                                </select>
                            </div>
                            <div class="form-group mb-3 link_input d-none">
                                <label class="mb-2">Link</label>
                                <input type="text" class="form-control " name="link"
                                       autocomplete="off"
                                       placeholder="Link">
                            </div>
                            <div class="form-group mb-3 adds_input d-none">
                                <label class="mb-2">Adds</label>
                                <select name="add_id" id="add_id"></select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.initial_date'); ?></label>
                                <input type="date" class="form-control daterange-basic" name="initial_date"
                                       data-time-picker="true"
                                       data-format="DD-MM-Y" autocomplete="off"
                                       placeholder="<?php echo app('translator')->get('translate.initial_date'); ?>" required>
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.final_date'); ?></label>
                                <input type="date" class="form-control daterange-basic" name="final_date"
                                       data-time-picker="true"
                                       data-format="DD-MM-Y" autocomplete="off"
                                       placeholder="<?php echo app('translator')->get('translate.final_date'); ?>" required>
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description_english'); ?></label>
                                    <textarea rows="7" cols="3" id="description_en" class="form-control"
                                              name="description"
                                              placeholder="<?php echo app('translator')->get('translate.description_english'); ?>"></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="mb-2"><?php echo app('translator')->get('translate.Image'); ?></label>
                                <div class="input-group" data-toggle="aizuploader" data-type="image"
                                     data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div
                                            class="input-group-text bg-soft-secondary font-weight-medium"><?php echo app('translator')->get('translate.browse'); ?></div>
                                    </div>
                                    <div class="form-control file-amount"><?php echo app('translator')->get('translate.choose_file'); ?></div>
                                    <input type="hidden" name="image" required class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                                <small class="text-muted">These images are visible in product details page gallery. Use 600x600 sizes images.</small>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title_kurdish'); ?></label>
                                <input type="text" class="form-control" name="title_ku"
                                       placeholder="<?php echo app('translator')->get('translate.title_kurdish'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description_kurdish'); ?></label>
                                    <textarea rows="7" cols="3" id="description_ku" class="form-control"
                                              name="description_ku"
                                              placeholder="<?php echo app('translator')->get('translate.description_kurdish'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title_arabic'); ?></label>
                                <input type="text" class="form-control" name="title_ar"
                                       placeholder="<?php echo app('translator')->get('translate.title_arabic'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description_arabic'); ?></label>
                                    <textarea rows="7" cols="3" id="description_ar" class="form-control"
                                              name="description_ar"
                                              placeholder="<?php echo app('translator')->get('translate.description_arabic'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical form modal -->
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/banner/create.blade.php ENDPATH**/ ?>