<!-- Vertical Edit form modal -->

<div id="modal_form_vertical_edit" class="modal fade">
    <div class="modal-dialog modal-full">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h5 class="modal-title text-white"><?php echo app('translator')->get('translate.edit_banner'); ?></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="<?php echo e(route('banners.update',[$banner->id])); ?>" class="form-validate-jquery main_form_edit" id="main_form_edit">
                    <?php echo e(method_field('PUT')); ?>

                    <?php echo e(csrf_field()); ?>

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en_edit" class="nav-link active"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.en'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku_edit" class="nav-link"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.ku'); ?></a></li>
                        <li class="nav-item"><a href="#lang_ar_edit" class="nav-link"
                                                data-toggle="tab"><?php echo app('translator')->get('translate.ar'); ?></a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title_english'); ?></label>
                                <input type="text" class="form-control" name="title"
                                       value="<?php echo e($banner->getTranslation('title','en' ,false)); ?>" id="title" required
                                       placeholder="<?php echo app('translator')->get('translate.title_english'); ?>">
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label"><?php echo app('translator')->get('translate.banner_type'); ?></label>
                                <select name="banner_type" id="banner_type_edit" class="form-control">
                                    <option value="normal"
                                            <?php if($banner->banner_type == 'normal'): ?> selected <?php endif; ?>><?php echo app('translator')->get('translate.normal'); ?></option>
                                    <option value="link"
                                            <?php if($banner->banner_type == 'link'): ?> selected <?php endif; ?>><?php echo app('translator')->get('translate.link'); ?></option>
                                    <option value="product"
                                            <?php if($banner->banner_type == 'product'): ?> selected <?php endif; ?>><?php echo app('translator')->get('translate.product'); ?></option>
                                </select>
                            </div>
                            <div
                                class="form-group mb-3 link_input_edit <?php if($banner->banner_type != 'link'): ?>  d-none <?php endif; ?>">
                                <label class="mb-2">Link</label>
                                <input type="text" class="form-control " name="link" <?php if($banner->banner_type == 'link'): ?> value="<?php echo e($banner->data_type); ?>" <?php endif; ?>
                                       autocomplete="off"
                                       placeholder="Link">
                            </div>
                            <div
                                class="form-group mb-3 adds_input_edit <?php if($banner->banner_type != 'product'): ?>  d-none <?php endif; ?>">
                                <label class="mb-2">Adds</label>
                                <select name="add_id" id="add_id_edit">
                                    <?php if($banner->banner_type == 'product'): ?>
                                        <option value="<?php echo e($banner?->adds?->id); ?>"><?php echo e($banner?->adds?->title); ?></option>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.initial_date'); ?></label>
                                <input type="date" class="form-control daterange-basic" name="initial_date"
                                       value="<?php echo e($banner->initial_date); ?>"
                                       id="initial_date"
                                       data-time-picker="true"
                                       data-format="DD-MM-Y" autocomplete="off"
                                       placeholder="<?php echo app('translator')->get('translate.initial_date'); ?>" required>
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.final_date'); ?></label>
                                <input type="date" class="form-control daterange-basic" name="final_date"
                                       value="<?php echo e($banner->final_date); ?>"
                                       id="final_date"
                                       data-time-picker="true"
                                       data-format="DD-MM-Y" autocomplete="off"
                                       placeholder="<?php echo app('translator')->get('translate.final_date'); ?>" required>
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description_english'); ?></label>
                                    <textarea rows="7" cols="3" id="description_en_edit" class="form-control"
                                              name="description"
                                              placeholder="<?php echo app('translator')->get('translate.description_english'); ?>"><?php echo e($banner->getTranslation('description','en' ,false)); ?></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="mb-2">Image</label>
                                <div class="input-group" data-toggle="aizuploader" data-type="image"
                                     data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div
                                            class="input-group-text bg-soft-secondary font-weight-medium"><?php echo app('translator')->get('translate.browse'); ?></div>
                                    </div>
                                    <div class="form-control file-amount"><?php echo app('translator')->get('translate.choose_file'); ?></div>
                                    <input type="hidden" name="image" id="image" required value="<?php echo e($banner->image); ?>"
                                           class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                                <small class="text-muted">These images are visible in product details page gallery. Use 600x600 sizes images.</small>

                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title_kurdish'); ?></label>
                                <input type="text" class="form-control" name="title_ku" id="title_ku"
                                       value="<?php echo e($banner->getTranslation('title','ku',false)); ?>"
                                       placeholder="<?php echo app('translator')->get('translate.title_kurdish'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description_kurdish'); ?></label>
                                    <textarea rows="7" id="description_ku_edit" cols="3" class="form-control"
                                              name="description_ku"
                                              placeholder="<?php echo app('translator')->get('translate.description_kurdish'); ?>"><?php echo e($banner->getTranslation('description','ku',false)); ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title_arabic'); ?></label>
                                <input type="text" class="form-control" name="title_ar" id="title_ar"
                                       value="<?php echo e($banner->getTranslation('title','ar',false)); ?>"
                                       placeholder="<?php echo app('translator')->get('translate.title_arabic'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description_arabic'); ?></label>
                                    <textarea rows="7" id="description_ar_edit" cols="3" class="form-control"
                                              name="description_ar"
                                              placeholder="<?php echo app('translator')->get('translate.description_arabic'); ?>"><?php echo e($banner->getTranslation('description','ar',false)); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical Edit form modal -->

<script>
    $("#banner_type_edit").select2({
        dropdownParent: $('#modal_form_vertical_edit')
    });

    $("#banner_type_edit").change(function () {

        var type = $(this).val();

        if (type == 'product') {
            $(".link_input_edit").addClass('d-none');
            $(".adds_input_edit").removeClass('d-none');

        } else if (type == 'link') {
            $(".link_input_edit").removeClass('d-none');
            $(".adds_input_edit").addClass('d-none');
        } else {
            $(".link_input_edit").addClass('d-none');
            $(".adds_input_edit").addClass('d-none');
        }


    });

    $("#add_id_edit").select2({
        placeholder: "Search For Adds",
        dropdownParent: $("#modal_form_vertical_edit"),
        ajax: {
            url: "<?php echo e(route('banners.get_adds')); ?>",
            type: "post",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    _token: "<?php echo e(csrf_token()); ?>",
                    search: params.term // search term
                };
            },
            processResults: function (response) {

                var results = [];
                for (var i = 0; i < response.length; i++) {
                    results.push({
                        id: response[i].id,
                        text: response[i].text,
                        disabled: response[i].locked === 1
                    });
                }
                return {
                    results: results
                };
            },
            cache: true
        }

    });

</script>
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/banner/update.blade.php ENDPATH**/ ?>